/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Adc.h
  \brief    	Analog to Digital conversion definitions and general configuration parameters
  \author   	Freescale Semiconductor
  \author     r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	6/27/2008 9:56:17 AM
  \warning    ADC_CLK_PRESCALER must be set using the system clock reference. Otherwise,  \n
              ADC0 Clock might run out over normal operation. ADC clock must not run over \n
              12 MHz.
  
  * History:
  
*/
/****************************************************************************************/
#ifndef __ADC_H__
 #define __ADC_H__
 
 #include "Adc_Cfg.h"
 #include "edma_init.h"
 #include "Derivative.h"
 
 /** ADC receive FIFO register address */
 #define RFIFO0_POP   0xFFF80032
 /** ADC cFIFO register address        */
 #define CFIFO0_PUSH  0xFFF80010
 /** ADC Trigger Modes                 */
 #define DISABLE_Q             (uint8_t)0x0
 #define SW_TRIG_SS            (uint8_t)0x1
 #define LOW_GATED_EXT_SS      (uint8_t)0x2
 #define HIGH_GATED_EXT_SS     (uint8_t)0x3
 #define FALLING_EXT_SS        (uint8_t)0x4
 #define RISING_EXT_SS         (uint8_t)0x5
 #define FALL_OR_RISE_EXT_SS   (uint8_t)0x6
 #define SW_TRIG_CS            (uint8_t)0x9
 #define LOW_GATED_EXT_CS      (uint8_t)0xA
 #define HIGH_GATED_EXT_CS     (uint8_t)0xB
 #define FALLING_EXT_CS        (uint8_t)0xC
 #define RISING_EXT_CS         (uint8_t)0xD
 #define FALL_OR_RISE_EXT_CS   (uint8_t)0xE 

  /*------------- Defines --------------------------------------------------------------*/
 /** Enables or Disables ADC Calibration feature      */
 #define ADC_CALIBRATION_MODE                             (ADC_CAL_DISABLE)
 /** Writes configuration command to on-chip ADC      */
 #define ADC_WRITE_CONFIG_CMD(u32CtrlCmd, cFifoBuffer)    (EQADC.CFPR[cFifoBuffer].R = (uint32_t)u32CtrlCmd)
 /** Writes control command to on-chip ADC            */
 #define ADC_WRITE_CONTROL_CMD(Cmd, cFifoBuffer)          (EQADC.CFCR[cFifoBuffer].R = (uint16_t)Cmd)
 /** Adc Queue Flag                                   */ 
 #define ADC_END_OF_QUEUE_FLAG(u8AdcFifoBuffer)           (EQADC.FISR[u8AdcFifoBuffer].B.EOQF)
 /** Adc RFIFO Drain Flag register                    */
 #define ADC_RFIFO_FLAG(u8AdcFifoBuffer)                  (EQADC.FISR[u8AdcFifoBuffer].B.RFDF)
 /** Adc FIFO Pop Data. Retrieves data from specific FIFO buffer (0-5) */
 #define ADC_READ_RESULT(u8AdcFifoBuffer)                 (EQADC.RFPR[u8AdcFifoBuffer].R) 
 /** Set SSE bit on CFCRx register                    */
 #define ADC_SET_SSE_BIT(u8Fifo)                          (EQADC.CFCR[u8Fifo].B.SSE = (uint8_t)0x1)
 /** Invalidates CFIFO buffer                         */
 #define ADC_INVALIDATE_CFIFO(u8FifoNum)                  (EQADC.CFCR[u8FifoNum].R   = 0x0200)
 /** Writes to ADC Interrupt and DMA control register */
 #define ADC_DMA_CR(u8Buffer,u16Value)                     (EQADC.IDCR[u8Buffer].R = (uint16_t)u16Value)

/*------------- Macro Functions ------------------------------------------------------*/
 #define ADC_CONVERT_AND_READ(u8AdcChannel,u16CollectAdcResult)    vfnStart_Conversion_fnc(u8AdcChannel, ADC_CALIBRATION_MODE); \
                                                                    u16CollectAdcResult = (uint16_t)((uint16_t)u16Read_Adc_Result(ADC_FIFO_BUFFER) >> (uint16_t)2)

 #define ADC_CONVERT_AND_READ_EDMA_FLG(u8AdcChannel)               vfnStart_Conversion_fnc(u8AdcChannel, ADC_CALIBRATION_MODE); \
                                                                   vfnWait_Till_Valid_Adc_Result(ADC_FIFO_BUFFER)
 
/*------------- Function Prototypes ---------------------------------------------------*/
void vfnAdc_Init(void);
uint16_t u16Read_Adc_Result(uint8_t u8AdcFifoBuffer);
void vfnInitAdc_Calibration(uint32_t u32dac);
void vfnStart_Conversion_fnc(uint8_t u8AdcChannel, uint32_t u32Calibration);
void vfnWait_Till_Valid_Adc_Result(uint8_t u8AdcFifoBuffer);

#endif
